/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher.util;

import java.nio.file.Path;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class ServiceLoaderUtils {
    public static <T> Stream<T> streamServiceLoader(Supplier<ServiceLoader<T>> slSupplier, Consumer<ServiceConfigurationError> errorConsumer) {
        return ServiceLoaderUtils.streamWithErrorHandling(slSupplier.get(), errorConsumer);
    }

    public static <T> Stream<T> streamWithErrorHandling(ServiceLoader<T> sl, Consumer<ServiceConfigurationError> errorConsumer) {
        return sl.stream().map(p -> {
            try {
                return p.get();
            }
            catch (ServiceConfigurationError sce) {
                errorConsumer.accept(sce);
                return null;
            }
        }).filter(Objects::nonNull);
    }

    public static String fileNameFor(Class<?> clazz) {
        return clazz.getModule().getLayer().configuration().findModule(clazz.getModule().getName()).flatMap(rm -> rm.reference().location()).map(uri -> Path.of(uri).getFileName().toString()).orElse("MISSING FILE");
    }
}

